//2018/06/29 東京の毎時気温データを取得し、極座標に展開する
let elements;   //グラフエレメントの配列

let heinenHeikin = 23.7;    //平均気温の平年値データ（棒グラフの基準となる）
let heinenSaikou = 27.7;    //最高気温の平年値
let heinenSaitei = 20.4;    //最低気温の平年値
let scale = 10;        //グラフの倍率

let csv;    //CSVデータを入れる場所

let curIndex = 0;     //「何番のエレメントまで描画するか」を入れる変数

let oresenAlpha = 0.0;  //折れ線グラフのアルファ

//グラフの中心のx, y座標
let cx = 0;
let cy = 0;

function preload(){
  csv = loadTable("data/temperature20180629.csv", "header");    //CSVデータの読み込み
}

function setup() {
  createCanvas(windowWidth, windowHeight);

  //データを読み込んで、グラフエレメントを作る
  let num = csv.getRowCount();  //CSVデータの行数を取得
  elements = new Array(num);        //行数の長さだけグラフエレメントの配列を作る
  csv.rows.forEach(function(row, i){
    let ele = new GraphElement();      //新しいグラフエレメントを作る
    ele.time = int(row.getString("time"));      //rowから"time"列のデータを整数値として取得
    ele.value = float(row.getString("temperature"));    //rowから"temperature"列のデータを小数値として取得
    ele.x = width/2;
    ele.y = height/2;
    ele.x2 = width/2;
    ele.y2 = height/2;
    ele.nagasa = ele.value * scale;   //棒グラフの長さを、気温の値に比例させる
    elements[i] = ele;      //配列に新しいエレメントを入れる
  });
}

function draw() {
  background(0);                //背景を黒で塗りつぶす

  //極座標の中心を、画面の中心に
  cx = width/2;
  cy = height/2;

  //現在のミリ秒数から、描画すべきインデックスを計算する
  curIndex = int(millis() / 100);

  //グラフの各頂点の位置計算
  elements.forEach(function(ele, i){
    if(i < curIndex){
      let kakudo = PI * 2 / elements.length * i - PI / 2; //中心に対する角度を求める（360度を頂点の数で割り、頂点の番号を掛ける。最後の「-PI/2」は90度ずらすため）
      let ix = cx + ele.nagasa * cos(kakudo);   //三角関数を使ってx座標を求める
      let iy = cy + ele.nagasa * sin(kakudo);   //三角関数を使ってy座標を求める
      ele.x2 += (ix - ele.x2) / 20.0;                //グラフの終点の位置を動かす
      ele.y2 += (iy - ele.y2) / 20.0;                //グラフの終点の位置を動かす
    }
  });

  //10℃ごとに補助線を入れる
  stroke(50);
  noFill();
  circle(cx, cy, 10 * scale * 2);
  circle(cx, cy, 20 * scale * 2);
  circle(cx, cy, 30 * scale * 2);
  circle(cx, cy, 40 * scale * 2);

  //グラフの軸を描画する
  elements.forEach(function(ele, i){
    noStroke();
    fill(255);
    textAlign(CENTER, CENTER);
    let r = 420;
    let angle = PI * 2 / elements.length * i - PI / 2;
    let tx = cx + r * cos(angle);
    let ty = cy + r * sin(angle);
    text(ele.time, tx, ty);    //eleの「time」変数の値を使い、時間を描画する

    r = 400;
    angle = PI * 2 / elements.length * i;
    tx = cx + r * cos(angle);
    ty = cy + r * sin(angle);
    stroke(50);
    noFill();
    line(cx, cy, tx, ty);
  });

  //各点が全て現れた頃に、平年値の線や、折れ線を出す。
  if(millis() > 4000){
    //平均気温の平年値の線を描画
    noFill();
    stroke(255, 255, 255, oresenAlpha);
    strokeWeight(1);
    circle(cx, cy, heinenHeikin * scale * 2);   //circle()は直径指定なので2倍する

    //最高気温の平年値の線を描画
    noFill();
    stroke(255, 0, 0, oresenAlpha);
    strokeWeight(1);
    circle(cx, cy, heinenSaikou * scale * 2);


    //最低気温の平年値の線を描画
    noFill();
    stroke(0, 0, 255, oresenAlpha);
    strokeWeight(1);
    circle(cx, cy, heinenSaitei * scale * 2);

    //各点をつなぐ折れ線の描画
    oresenAlpha += (255 - oresenAlpha) / 10.0;
    stroke(255, 255, 255, oresenAlpha);
    fill(255, 100);
    beginShape();
    elements.forEach(function(ele, i){
      vertex(ele.x2, ele.y2);
    });
    endShape(CLOSE);
  }

  //グラフの各頂点に丸い点を打つ
  elements.forEach(function(ele, i){
    if(i < curIndex){
      noStroke();
      fill(255, 255 - oresenAlpha);
      circle(ele.x2, ele.y2, 10);
    }
  });

  //左上にタイトルを入れる
  textAlign(LEFT, CENTER);
  fill(255);
  noStroke();
  text("2018年6月29日の気温の推移と平年値", 100, 50);
}
