//2018/06/29 東京の毎時気温データを取得する
let elements;   //グラフエレメントの配列

let heinenHeikin = 23.7;    //平均気温の平年値データ（棒グラフの基準となる）
let heinenSaikou = 27.7;    //最高気温の平年値
let heinenSaitei = 20.4;    //最低気温の平年値
let scale = 10;        //グラフの倍率

let csv;    //CSVデータを入れる場所

let curIndex = 0;     //「何番のエレメントまで描画するか」を入れる変数

let oresenAlpha = 0.0;  //折れ線グラフのアルファ

function preload(){
  csv = loadTable("data/temperature20180629.csv", "header");    //CSVデータの読み込み
}

function setup() {
  createCanvas(windowWidth, windowHeight);

  //データを読み込んで、グラフエレメントを作る
  let num = csv.getRowCount();  //CSVデータの行数を取得
  elements = new Array(num);        //行数の長さだけグラフエレメントの配列を作る
  csv.rows.forEach(function(row, i){
    let ele = new GraphElement();      //新しいグラフエレメントを作る
    ele.time = int(row.getString("time"));      //rowから"time"列のデータを整数値として取得
    ele.value = float(row.getString("temperature"));    //rowから"temperature"列のデータを小数値として取得
    ele.x = 100 + 800 / (elements.length-1) * i;   //エレメントを横に並べるためのxの設定
    ele.y = height - 100;    //エレメントのyを画面下に設定
    ele.x2 = ele.x;         //エレメントのx2（グラフの終点）をxと同じ値に
    ele.y2 = ele.y;         //エレメントのy2をyと同じ値に
    ele.nagasa = ele.value * scale;   //棒グラフの長さを、気温の値に比例させる
    elements[i] = ele;      //配列に新しいエレメントを入れる
  });
}

function draw() {
  background(0);                //背景を黒で塗りつぶす

  //現在のミリ秒数から、描画すべきインデックスを計算する
  curIndex = int(millis() / 100);

  //グラフの各点の位置計算
  elements.forEach(function(ele, i){
    if(i < curIndex){
      let iy = ele.y - ele.nagasa;                      //グラフの終点の目標位置を決める
      ele.y2 += (iy - ele.y2) / 20.0;                //グラフの終点の位置を動かす
    }
  });

  //x軸の線の描画
  let zeroY = height - 100;
  noFill();
  stroke(255, 255, 255);
  strokeWeight(1);
  line(100, zeroY, 100 + 800, zeroY);

  //各点が全て現れた頃に、平年値の線や、折れ線を出す。
  if(millis() > 4000){
    //平均気温の平年値の線を描画
    let heinenY = height - 100 - heinenHeikin * scale;
    noFill();
    stroke(150, 150, 150, oresenAlpha);
    strokeWeight(1);
    line(100, heinenY, 100 + 800, heinenY);

    noStroke();
    fill(255, 255, 255, oresenAlpha);
    textAlign(LEFT, CENTER);
    text(heinenHeikin, 100 + 800 + 20, heinenY);

    //最高気温の平年値の線を描画
    let heinenY2 = height - 100 - heinenSaikou * scale;
    noFill();
    stroke(255, 0, 0, oresenAlpha);
    strokeWeight(1);
    line(100, heinenY2, 100 + 800, heinenY2);

    noStroke();
    fill(255, 255, 255, oresenAlpha);
    textAlign(LEFT, CENTER);
    text(heinenSaikou, 100 + 800 + 20, heinenY2);

    //最低気温の平年値の線を描画
    let heinenY3 = height - 100 - heinenSaitei * scale;
    noFill();
    stroke(0, 0, 255, oresenAlpha);
    strokeWeight(1);
    line(100, heinenY3, 100 + 800, heinenY3);

    noStroke();
    fill(255, 255, 255, oresenAlpha);
    textAlign(LEFT, CENTER);
    text(heinenSaitei, 100 + 800 + 20, heinenY3);

    //各点をつなぐ折れ線の描画
    oresenAlpha += (255 - oresenAlpha) / 10.0;
    stroke(255, 255, 255, oresenAlpha);
    noFill();
    beginShape();
    elements.forEach(function(ele, i){
      vertex(ele.x2, ele.y2);
    });
    endShape();
  }

  //グラフの各点の描画
  elements.forEach(function(ele, i){
    if(i < curIndex){
      noStroke();
      fill(255, 100);
      circle(ele.x2, ele.y2, 20);
    }
    noStroke();
    fill(255);
    textAlign(CENTER, CENTER);
    text(ele.time, ele.x, ele.y + 20);    //eleの「time」変数の値を使い、時間を描画する
    circle(ele.x, ele.y, 4);
  });

  textAlign(LEFT, CENTER);
  text("2018年6月29日の気温の推移と平年値", 100, 50);
}
