//感染症のシミュレーションとグラフの記録
let maru = new Array(100);  //Maruクラスのインスタンスを入れる配列を宣言する
let speed = 2;      //maruそれぞれの動きのスピード
let graph;  //グラフを描くキャンバス
let t = 0;  //経過フレーム数

function setup(){
  createCanvas(windowWidth, windowHeight);  //ウィンドウサイズの指定
  for(let i = 0; i < maru.length; i=i+1){
    maru[i] = new Maru();  //Maruクラスから1つ実体化（インスタンス化）する
    maru[i].x = random(width);     //maruの初期座標をランダムで決める
    maru[i].y = random(height);
    let angle = random(2 * PI);   //角度をランダムで求める
    maru[i].addX = speed * cos(angle);    //speedと角度から、三角関数を使ってmaruの移動量を求める
    maru[i].addY = speed * sin(angle);
  }
  maru[0].state = 1;  //第一号感染者を作る
  graph = createGraphics(windowWidth, 100); //グラフ用に別のキャンバスを作る
  graph.background(200, 100);  //graphの背景を半透明のグレーで塗る
}

function draw(){
  background(0);
  for(let i = 0; i < maru.length; i=i+1){
    maru[i].update();  //maruのupdate()メソッドを呼び、座標を更新させる
    //壁で跳ね返る
    if(maru[i].x < 0 || maru[i].x > width){
      maru[i].addX = maru[i].addX * -1;
    }
    if(maru[i].y < 0 || maru[i].y > height){
      maru[i].addY = maru[i].addY * -1;
    }
    //maruどうしの衝突判定（総当たり）
    for(let j = 0; j < maru.length; j=j+1){
      if(i < j){    //自分より若い番号とは衝突判定を行わない（処理を軽くするため）
        let aite = maru[j];     //相手を一人決める
        let kyori = dist(maru[i].x, maru[i].y, aite.x, aite.y);   //自分と相手との距離を測る
        //衝突していたら（2人の半径の和よりも、距離が縮まっていたら）、反発させる
        if(kyori < maru[i].r + aite.r){
          let kakudo1 = atan2(aite.y - maru[i].y, aite.x -maru[i].x); //自分から相手への角度を求める
          let kakudo2 = kakudo1 + PI;          //相手から自分への角度を求める
          //自分を「相手から自分への角度」に反発させる
          maru[i].addX = speed * cos(kakudo2);  //角度をもとに、speedをx方向に分解し、自分の移動量を変える
          maru[i].addY = speed * sin(kakudo2);  //角度をもとに、speedをy方向に分解、自分の移動量を変える
          //相手を「自分から相手への角度」に反発させる
          aite.addX = speed * cos(kakudo1);
          aite.addY = speed * sin(kakudo1);
          //相手が感染していたら、自分を感染させる
          if(aite.state == 1){
            maru[i].state = 1;
          }
          //自分が感染していたら、相手を感染させる
          if(maru[i].state == 1){
            aite.state = 1;
          }
        }
      }
    }
    maru[i].draw();  //maruのdraw()メソッドを呼び出す
  }
  //統計を取る
  let totalKansensha = 0;   //総感染者数
  let totalKaifukusha = 0;  //総回復者数
  let totalKenkosha = 0;    //総健康者数
  for(let i = 0; i < maru.length; i=i+1){
    if(maru[i].state == 0){
      totalKenkosha = totalKenkosha + 1;
    }
    if(maru[i].state == 1){
      totalKansensha = totalKansensha + 1;
    }
    if(maru[i].state == 2){
      totalKaifukusha = totalKaifukusha + 1;
    }
  }
  //統計をもとにグラフを描く
  let kenkoH = graph.height * totalKenkosha / maru.length;
  let kansenH = graph.height * totalKansensha / maru.length;
  let kaifukuH = graph.height * totalKaifukusha / maru.length;
  graph.noStroke();
  graph.fill(100, 100, 255, 100);  //健康色
  graph.rect(t, 0, 1, kenkoH);
  graph.fill(100, 255, 100, 100);  //回復色
  graph.rect(t, kenkoH, 1, kaifukuH);
  graph.fill(255, 100, 100, 100);  //感染色
  graph.rect(t, kenkoH + kaifukuH, 1, kansenH);
  image(graph, 0, 0);
  t = t + 0.5;
}
function mousePressed(){
  save(graph, 'graph.png');
}

//Maruクラス
class Maru {
  constructor(){
    this.x = 0;   //x座標
    this.y = 0;   //y座標
    this.addX = 0;  //x移動量
    this.addY = 0;  //y移動量
    this.r = 5;   //半径
    this.state = 0; //0=健康, 1=感染, 2=回復
    this.kansenDays = 0;    //感染からの経過日数
  }
  //位置計算と健康状態の計算
  update(){
    //感染していたら感染日数を数え、300を超えたらstateを「回復」に変える
    if(this.state == 1){
      this.kansenDays = this.kansenDays + 1;  //感染日数を増やす
      if(this.kansenDays > 300){
        this.state = 2;
      }
    }
    this.x = this.x + this.addX;  //自分のxにaddXを加える
    this.y = this.y + this.addY;  //自分のyにaddYを加える
  }
  //描画
  draw(){
    noStroke();
    fill(100, 100, 255);
    if(this.state == 1){    //感染していた場合
      fill(255, 100, 100);
    }
    if(this.state == 2){    //回復していた場合
      fill(100, 255, 100);
    }
    circle(this.x, this.y, this.r*2);
  }
}
