/* 雨の表現 */
let rain;

function setup(){
  createCanvas(windowWidth, windowHeight);  //ウィンドウサイズの指定
  rain = new Rain();
}

function draw(){
  background(0);
  rain.x = width/2;
  rain.y = height/2;
  rain.draw();

  fill(100);
  noStroke();
  text("マウスを右に動かすと、描画される雨が増えます", 30, height-30);
}

//雨を描くためのクラス
class Rain {
  constructor(){
    this.x = 0;       //雨を描くエリアの中心座標
    this.y = 0;
    this.pts = new Array(2000);      //雨の点のxy座標を入れておく
    this.addX = new Array(this.pts.length);   //雨に少し揺らぎを与えるため、毎フレームaddXを加える
    this.drawingPtNum = 0;    //この番号までの雨を降らせる
    this.iDrawingPtNum = 0;    //drawingPtNumの目標値（ゆっくり変化させるため）
    this.hankei = 300;        //雨のエリアの半径
    //雨の点の座標をランダムで決める
    for(let i = 0; i < this.pts.length; i++){
      let r = random(this.hankei);   //半径をランダムで決める
      let angle = random(2 * PI);   //角度をランダムで決める
      this.pts[i] = createVector(r * cos(angle), r * sin(angle));   //半径と角度からx,yを求める
      this.addX[i] = random(-0.2, 0.2);   //雨に揺らぎを与えるためのaddXをランダムで決める
    }
  }
  //雨を描画する
  draw(){
    this.iDrawingPtNum = mouseX / width * this.pts.length;
    //描画する雨の数を、目標値にゆっくり変化させる
    this.drawingPtNum += (this.iDrawingPtNum - this.drawingPtNum) / 20.0;
    //雨を描画する
    for(let i = 0; i < this.pts.length; i++){
      if(i < this.drawingPtNum){
        let pt = this.pts[i];
        noFill();
        stroke(0, 100, 255);
        point(this.x + pt.x, this.y + pt.y);  //雨を点として描く
        pt.x += this.addX[i];   //雨の点を左右に揺らがせる
        pt.y += 2;    //雨の点を下に動かす
        let r = dist(0, 0, pt.x, pt.y);
        //任意の半径から外に出てしまったら、円の上弦の上に雨を移動させる
        if(r > this.hankei){
          let angle = random(PI, 2*PI);
          pt.x = this.hankei * cos(angle);
          pt.y = this.hankei * sin(angle);
        }
      }
    }
  }
}
