let nodes = new Array(30);
let connectMode = false;
let selectedNode = null;
let curAngle = 0.0;

function setup(){
  createCanvas(windowWidth, windowHeight);  //ウィンドウサイズの指定

  //ノードを作る
  for (let i = 0; i < nodes.length; i++) {
    nodes[i] = new Node();
    nodes[i].id = i;  //idをふる
    nodes[i].x = random(width);
    nodes[i].y = random(height);
    nodes[i].ix = nodes[i].x;
    nodes[i].iy = nodes[i].y;
  }
  //最初に適当に友達を作る
  for (let i = 0; i < nodes.length; i++) {
    let node = nodes[i];
    for (let j = 0; j < nodes.length; j++) {
      if (i != j) {
        let rand = random(100);  //サイコロをふる
        if (rand < 5.0 && node.hasFriend(nodes[j]) == false) {
          node.addFriend(nodes[j]);
        }
      }
    }
  }
}

function draw(){
  background(0);
  if (connectMode == true) {
    fill(255, 255, 255, 50);
    rect(0, 0, width, height);
  }
  //接続モードでない場合
  if (connectMode != true) {
    //選択ノードが空でない場合
    if (selectedNode != null) {
      //選択ノードの行き先をマウスの座標に
      selectedNode.ix = mouseX;
      selectedNode.iy = mouseY;
      //友達を自分の周辺に
      let friends = selectedNode.friends;
      for (let i = 0; i < friends.length; i++) {
        let angle = TWO_PI / friends.length * i;
        angle += curAngle;
        let ix = selectedNode.x + 100 * cos(angle);
        let iy = selectedNode.y + 100 * sin(angle);
        friends[i].ix = ix;
        friends[i].iy = iy;
      }
    }
  } else {  //接続モードの場合
    if (selectedNode != null) {
      stroke(255);
      noFill();
      line(selectedNode.x, selectedNode.y, mouseX, mouseY);
    }
  }

  //ノードの位置計算、描画
  for (let i = 0; i < nodes.length; i++) {
    nodes[i].update();
    nodes[i].draw();
  }

  fill(200);
  noStroke();
  textSize(12);
  textLeading(22);
  text("optionを押しながら2つのノードを結ぶと関係性（エッジ）が生まれます。\n既につながっている2つのノードを結ぶと関係性が切れます。", 20, height - 50);

  curAngle += 0.01;
}

function mousePressed() {
  selectedNode = null;
  if (connectMode == true) {
    //選択ノードをマウスオーバーされたノードにする
    for (let i = 0; i < nodes.length; i++) {
      if (nodes[i].isMouseOver()) {
        selectedNode = nodes[i];
        selectedNode.isSelected = true;
        break;
      }
    }
  } else {
    //選択ノードをマウスオーバーされたノードにする
    for (let i = 0; i < nodes.length; i++) {
      if (nodes[i].isMouseOver()) {
        selectedNode = nodes[i];
        selectedNode.isSelected = true;
        break;
      }
    }
  }
}
function mouseReleased() {
  if (connectMode == true) {
    //ノードが選択されている場合
    if (selectedNode != null) {
      //マウスオーバーされていれば
      for (let i = 0; i < nodes.length; i++) {
        let node = nodes[i];
        if (node != selectedNode) {
          if (node.isMouseOver() == true) {
            if (selectedNode.hasFriend(node)) {
              selectedNode.removeFriend(node);
            } else {
              selectedNode.addFriend(node);
            }
          }
        }
      }
    }
  } else {
  }
  //全員選択解除
  for (let i = 0; i < nodes.length; i++) {
    nodes[i].isSelected = false;
  }
  selectedNode = null;
}

function keyPressed() {
  if (keyCode == ALT) {
    connectMode = true;
  }
}
function keyReleased() {
  if (keyCode == ALT) {
    connectMode = false;
  }
}
