class Node {
  constructor(){
    this.id = 0;
    this.x = 0;
    this.y = 0;
    this.ix = 0;
    this.iy = 0;
    this.r = 0;
    this.ir = 10.0;
    this.isSelected = false;
    this.label;
    this.friends = new Array(0);
  }

  //友達追加
  addFriend(newFriend) {
    if(this.hasFriend(newFriend) != true){
      this.friends = append(this.friends, newFriend);
    }
  }
  //友達削除=========================================
  removeFriend(theFriend) {
    if (this.friends.length > 0) {
      let newArray = new Array(friends.length-1);  //1つ小さな配列を作る
      //その友達以外を新しい配列に追加
      let j = 0;
      for (let i = 0; i < this.friends.length; i++) {
        if (this.friends[i] != theFriend) {
          newArray[j] = this.friends[i];
          j++;
        }
      }
      this.friends = newArray;
    }
  }
  //位置計算
  update() {
    this.ir = 10 + 10 * this.friends.length;
    this.x += (this.ix - this.x) / 10.0;
    this.y += (this.iy - this.y) / 10.0;
    this.r += (this.ir - this.r) / 10.0;
  }
  //描画
  draw() {
    stroke(255, 255, 255, 100);
    noFill();
    for (let i = 0; i < this.friends.length; i++) {
      line(this.x, this.y, this.friends[i].x, this.friends[i].y);
    }
    noStroke();
    fill(255, 255, 255, 100);
    if(this.isMouseOver() || this.isSelected == true){
      fill(255, 255, 255, 200);
    }
    circle(this.x, this.y, this.r*2);
  }
  //そのノードを友達に持っているかどうかを返す
  hasFriend(node){
    for (let i = 0; i < this.friends.length; i++) {
      if (this.friends[i] == node) {
        return true;
      }
    }
    return false;
  }
  //マウスオーバーしているかどうかを返す
  isMouseOver() {
    if (dist(mouseX, mouseY, this.x, this.y) < this.r) {
      return true;
    }
    return false;
  }
}
