class DensityCircle {

  constructor(densityData, radius) {
    this.density = densityData;   //密度
    this.r = radius;    //円の半径
    //人口密度のぶんだけpx, pyを作る
    this.pts = new Array(int(this.density));
    //粒の初期座標の計算
    for (let i = 0; i < this.pts.length; i++) {
      let rad = random(this.r);          //ランダムで中心からの半径を計算
      let angle = random(TWO_PI);   //ランダムで角度を計算
      this.pts[i] = createVector(rad * cos(angle), rad * sin(angle));       //半径と角度からx, y座標を計算する
    }
    this.totalArea = this.r * this.r * PI;         //円全体の総面積を計算（半径×半径×円周率）
    this.pArea = this.totalArea / this.pts.length;    //総面積を粒の数で割、パーソナルエリアを算出する
    this.pR = sqrt(this.pArea / PI);          //パーソナルエリアの半径を計算する
  }

  //描画メソッド。引数は中心座標
  drawDensity(cx, cy) {
    colorMode(HSB);
    for (let i = 0; i < this.pts.length; i++) {
      let pt = this.pts[i];   //粒を一つ取り出す
      noStroke();
      fill(100, 100, 200, 100);
      circle(cx + pt.x, cy + pt.y, 4);      //粒の描画
      stroke(30, 100, 200, 100);
      noFill();
      circle(cx + pt.x, cy + pt.y, this.pR*2);    //パーソナルスペースの描画
      pt.x += random(-1, 1);    //ランダムの値だけ移動させる
      pt.y += random(-1, 1);
      //中心からの距離が円を超えたら、円の反対側に移動させる
      let d = sqrt(pow(pt.x, 2) + pow(pt.y, 2));  //三平方の定理で中心からの距離を求める
      if (d > this.r) {        //円をはずれていたら
        let angle = atan2(pt.y, pt.x);    //中心からの角度を求める
        angle += PI;      //角度を逆向きにする（180度回転させる）
        pt.x = this.r * cos(angle);    //求められた角度から座標を再び計算
        pt.y = this.r * sin(angle);
      }
      //他の粒との距離が、パーソナルスペースの半径よりも近くなってしまったら、反対方向に遠ざかる
      for (let j = 0; j < this.pts.length; j++) {
        if (i != j) {
          let ppt = this.pts[j];
          let d2 = dist(pt.x, pt.y, ppt.x, ppt.y);    //2点の距離
          if (d2 < this.pR*2) {           //距離がパーソナルスペースの半径より近ければ
            let angle = atan2(ppt.y - pt.y, ppt.x - pt.x);    //2点の角度を求める
            angle += PI;            //角度を逆向きに
            pt.x += 1 * cos(angle);    //求められた角度に向かって1ピクセル移動する
            pt.y += 1 * sin(angle);
          }
        }
      }
    }
    //外枠の描画
    stroke(180, 255, 255);
    noFill();
    circle(cx, cy, this.r*2);
  }
}
