let densityData = [30, 100, 1000];  //密度のデータ
let densRects = new Array(densityData.length);    //DensityRectクラスのインスタンス配列を宣言・初期化
let isPressed = false;            //マウスを押しているかどうか

function setup(){
  createCanvas(windowWidth, windowHeight);  //ウィンドウサイズの指定
  //densRectsの初期化
  for (let i = 0; i < densRects.length; i++) {
    densRects[i] = new DensityRect(densityData[i], 200, 200);  //初期化。引数は密度の値と矩形の幅・高さ
  }
}

function draw(){
  background(0);
  //densRects描画
  let margin = width/densRects.length;      //矩形どうしの間隔を計算
  for(let i = 0; i < densRects.length; i++){
   densRects[i].drawDensity(margin * i + margin/2, height/2, isPressed);   //densRectsに描画命令を出す
   //もしマウスを押している状態なら、ホームポジションに戻る命令を出す
   if(isPressed == true){
    densRects[i].goToHome();
   }
  }
}

function mousePressed(){
  isPressed = true;
}

function mouseReleased(){
  isPressed = false;
}
