class DensityRect {

  constructor(densityData, rectW, rectH) {
    this.density = densityData;    //密度データ
    this.w = rectW;   //矩形の幅
    this.h = rectH;   //矩形の高さ
    this.pts = new Array(int(this.density));  //ptsは粒のx座標、y座標。その数は密度に等しくする。
    //粒の初期座標をランダムで設定する
    for (let i = 0; i < this.pts.length; i++) {
      this.pts[i] = createVector(random(this.w), random(this.h));
    }
    this.totalArea = this.w * this.h;    //矩形の総面積（totalArea）を求める
    this.pArea = this.totalArea / this.pts.length;  //総面積と粒の数から、一粒あたりのパーソナルエリア（pArea）の面積を求める
    this.pWH = sqrt(this.pArea);    //一粒あたりのパーソナルエリアの面積からパーソナルエリアの辺の長さ（pWH）を求める
  }

  //描画メソッド。引数は中心座標と、パーソナルエリアを描画するか否か
  drawDensity(cx, cy, shouldDrawPersonalRect) {
    //左上の頂点のx, y座標を求める
    let x = cx - this.w/2;
    let y = cy - this.h/2;
    colorMode(HSB);
    for (let i = 0; i < this.pts.length; i++) {
      let pt = this.pts[i];
      //粒の描画
      noStroke();
      fill(100, 100, 200, 100);
      circle(x + pt.x, y + pt.y, 4);
      //パーソナルエリアの描画
      if (shouldDrawPersonalRect == true) {
        stroke(30, 100, 200, 100);
        noFill();
        rect(x + pt.x - this.pWH/2, y + pt.y - this.pWH/2, this.pWH, this.pWH);
      }
      //ランダムの量を移動させる
      pt.x += random(-1, 1);
      pt.y += random(-1, 1);
      //もし矩形から外れたら、反対側に移動させる
      if (pt.x < 0) {
        pt.x = this.w;
      } else if (pt.x > this.w) {
        pt.x = 0;
      }
      if (pt.y < 0) {
        pt.y = this.h;
      } else if (pt.y > this.h) {
        pt.y = 0;
      }
    }
    //外枠
    stroke(180, 255, 255);
    noFill();
    rect(x, y, this.w, this.h);
  }
  //ホームポジション（均等にマトリクス状に並べた時の位置）
  goToHome() {
    let curX = this.pWH / 2;
    let curY = this.pWH / 2;
    for (let i = 0; i < this.pts.length; i++) {
      let pt = this.pts[i];
      pt.x += (curX - pt.x) / 10.0;
      pt.y += (curY - pt.y) / 10.0;
      curX += this.pWH;
      if (curX > this.w) {
        curX = this.pWH/2;
        curY += this.pWH;
      }
    }
  }
}
