//中心点を回るノード。親子関係を作り、中心から順に並べる
let cx;    //回転の中心座標
let cy;
let r = 300;  //回転の半径
let nodes = new Array(10);  //ノードの配列

function setup(){
  createCanvas(windowWidth, windowHeight);  //ウィンドウサイズの指定
  cx = width/2;
  cy = height/2;

  //それぞれの円のノードの設定
  for (let i = 0; i < nodes.length; i++) {  //円の数だけ繰り返す
    nodes[i] = new Node();    //ノードの初期化
    //360度（2π）を円の数で割ると円1つあたりの角度のずれが計算できるので、それに配列のインデックスをかけると、その番号の円の回転角が計算できる。
    nodes[i].angle = 2 * PI / nodes.length * i;
    nodes[i].hue = 255 / nodes.length * i;
    nodes[i].hankei = 0.0;
    nodes[i].iHankei = 180;

    //ノードに子供を設定する
    let childNum = 1 + int(random(5));
    let count = 0;  //何回setChildrenを繰り返したか（何代子供がいるか）
    let limit = 3;  //setChildrenの回数限度（何代までか）
    nodes[i].setChildren(childNum, count, limit);

  }
  colorMode(HSB);
}

function draw(){
  background(0);
  for (let i = 0; i < nodes.length; i++) {    //円の数だけ繰り返す
    nodes[i].update(width/2, height/2);
    nodes[i].drawEdge();
  }
  for (let i = 0; i < nodes.length; i++) {    //円の数だけ繰り返す
    nodes[i].update(width/2, height/2);
    nodes[i].drawNode();
  }
}
