class Node {
  constructor(){
    this.hue = 0.0;  //色相
    this.angle = 0.0;  //親からの角度
    this.hankei = 0;  //距離
    this.iHankei = this.hankei;  //行くべき距離（目標値）
    this.cx = 0.0;
    this.cy = 0.0;  //中心のx, y
    this.r = 0.0;    //丸の半径
    this.ir = 5.0;    //丸の行くべき半径
    this.x = 0.0;    //自分のx座標
    this.y = 0.0;    //自分のy座標
    this.children = new Array(0); //子ノード
  }

  setChildren(num, count, limit) {  //numは子供の数、countは現在の階層の数、limitは連鎖を止めるべき階層番号
    count += 1;
    for (let i = 0; i < num; i++) {
      let child = new Node();     //子供を作る
      child.hue = this.hue + 0.3 * i;   //子供の色相を決める
      child.hankei = 0.0;   //子供の半径を決める
      child.iHankei = this.iHankei * 0.6;   //子供の色相の目標値を決める
      //子供のそのまた子供（孫）を作る
      let grandChildNum = 1 + int(random(this.children.length - 1));   //孫の数をランダムで決める
      if (count < limit) {
        child.setChildren(grandChildNum, count, limit);  //子供に同じ命令を出す
      }
      this.children.push(child);  //自分のchildren配列にchildを追加
    }
  }

  update(theCX, theCY) {
    this.cx = theCX;  //中心点の更新
    this.cy = theCY;
    this.x = this.cx + this.hankei * cos(this.angle);    //各々の円の回転の半径と角度から、円周上の点のx座標を計算（三角関数）
    this.y = this.cy + this.hankei * sin(this.angle);    //各々の円の回転の半径と角度から、円周上の点のy座標を計算
    this.hankei += (this.iHankei - this.hankei) / 40.0;  //枝をゆっくりのばす
    this.r += (this.ir - this.r) / 10.0;  //ノードの丸の半径をふわっと目標値に近づける
    //マウスオーバーしたら丸の半径を変える
    if (this.isMouseOver()) {
      this.ir = 20.0;
    } else {
      this.ir = 5.0;
    }
    //子供の角度と座標を更新する
    if (this.children.length > 0) {
      let anglePerChild = 0.3;    //子供一人当たりの角度
      let totalChildAngle = anglePerChild * (this.children.length - 1);   //子供全員分の角度
      for (let i = 0; i < this.children.length; i++) {
        let child = this.children[i];
        child.angle = this.angle - totalChildAngle / 2 + i* anglePerChild;
        child.update(this.x, this.y);
      }
      //      angle = angle + 0.01;      //各々の円の回転角を0.01ずつ増やす（すると回転して見える）
    }
  }

  //自分と子供の間に線（エッジ）を引く
  drawEdge() {
    stroke(0, 0, 100);
    noFill();
    line(this.cx, this.cy, this.x, this.y);
    for (let i = 0; i < this.children.length; i++) {
      let child = this.children[i];
      child.drawEdge();
    }
  }

  //自分の位置に丸を描く。さらに子供にも同じ命令を出す。
  drawNode() {
    fill(this.hue, 255, 255);
    noStroke();
    circle(this.x, this.y, this.r);
    if (this.children.length > 0) {
      for (let i = 0; i < this.children.length; i++) {
        let child = this.children[i];
        child.drawNode();
      }
    }
  }

  //自分の上にマウスが載っているかどうかを返す関数
  isMouseOver() {
    if (dist(mouseX, mouseY, this.x, this.y) < this.r) {
      return true;
    }
    return false;
  }
}
