//中心点を回る100個の円。回転の円周上の点からの距離にによって、各々の円の位置を決める
let cx;    //回転の中心座標
let cy;
let hankei = 300;  //回転の半径
let circulars = new Array(10);

function setup(){
  createCanvas(windowWidth, windowHeight);  //ウィンドウサイズの指定
  cx = width/2;
  cy = height/2;
  //それぞれの円の回転角を決める
  for (let i = 0; i < circulars.length; i=i+1) {  //円の数だけ繰り返す
    //360度（2π）を円の数で割ると円1つあたりの角度のずれが計算できるので、それに配列のインデックスをかけると、その番号の円の回転角が計算できる。
    circulars[i] = new CircularDiagram();
    circulars[i].angle = 2 * PI / circulars.length * i;
  }
  colorMode(HSB);
}

function draw(){
  background(0);
  for (let i = 0; i < circulars.length; i=i+1) {    //鉛管ダイアグラムの数だけ繰り返す
    let obj = circulars[i];   //1つの円環ダイアグラムを取り出す
    obj.x = cx + hankei * cos(obj.angle);    //円環ダイアグラムの角度を使い、x座標を計算する（三角関数）
    obj.y = cy + hankei * sin(obj.angle);    //環ダイアグラムの角度を使い、y座標を計算（三角関数）
    obj.update();   //objに位置計算をさせる
    obj.draw();     //objを描画
//    obj.angle = obj.angle + 0.005;      //各々の円の回転角を0.01ずつ増やす（すると回転して見える）
  }
}
