//円環ダイアグラムを扱うクラス
class CircularDiagram {
  constructor(){
    this.x = 0.0;
    this.y = 0.0;
    this.angle = 0.0; //中心点に対する回転角度
    this.hue = new Array(24); //子供の円の色相
    this.r = new Array(24);   //子供の点までの距離
    this.ir = new Array(24);   //rの目標値
    for(let i = 0; i < this.hue.length; i=i+1){
      this.hue[i] = 255 / this.hue.length * i;     //255を円の数で割ると円1つあたりの色相のずれが計算できるので、それに配列のインデックスをかけて、その番号の円の色相を計算する。
      this.r[i] = 0.0;      //子供のの点までの距離の目標値を最初は0に。それをupdate()の中で目標値irに徐々に近づける
      this.ir[i] = random(100);   //子供の点までの距離の目標値を-100から100の間のランダムで設定。
    }
  }
  //位置計算のメソッド
  update(){
    for(let i = 0; i < this.r.length; i=i+1){
      this.r[i] = this.r[i] + (this.ir[i] - this.r[i]) / 40.0;
    }
  }
  //描画のメソッド
  draw(){
    fill(0, 0, 200);
    noStroke();
//    circle(this.x, this.y, 5);  //自分の位置に円を描く
    //以下、子供の位置を計算し、描画する
    for(let i = 0; i < this.r.length; i=i+1){
      let childAngle = 2 * PI / this.r.length * i;    //2πを子供の総数で割って、それに子供の番号をかける
      let childX = this.x + this.r[i] * cos(childAngle);  //三角関数を使って子供のx座標を計算する
      let childY = this.y + this.r[i] * sin(childAngle);  //三角関数を使って子供のy座標を計算する
      stroke(255);
      noFill();
      line(this.x, this.y, childX, childY);        //自分から子供の位置まで直線を引く
      noStroke();
      fill(this.hue[i], 255, 255);    //色相を設定する
      circle(childX, childY, 10);     //子供の位置に円を描画する
    }
  }
}
