//中心点を回る100個の円。回転の円周上の点からの距離にによって、各々の円の位置を決める
let cx;    //回転の中心座標
let cy;
let r = 300;  //回転の半径
let angle = new Array(100);    //各々の円の回転角度
let hue = new Array(angle.length);    //各々の円の色相
let l = new Array(angle.length);    //回転の円周から各々の点までの距離
let il = new Array(angle.length);   //lの目標値

function setup(){
  createCanvas(windowWidth, windowHeight);  //ウィンドウサイズの指定
  cx = width/2;
  cy = height/2;
  //それぞれの円の回転角を決める
  for (let i = 0; i < angle.length; i=i+1) {  //円の数だけ繰り返す
    //360度（2π）を円の数で割ると円1つあたりの角度のずれが計算できるので、それに配列のインデックスをかけると、その番号の円の回転角が計算できる。
    angle[i] = 2 * PI / angle.length * i;
    //255を円の数で割ると円1つあたりの色相のずれが計算できるので、それに配列のインデックスをかけて、その番号の円の色相を計算する。
    hue[i] = 255 / hue.length * i;
    //回転の円周から各々の点までの距離の目標値を最初は0に。それをdraw()の中で目標値irに徐々に近づける
    l[i] = 0.0;
    //回転の円周から各々の点までの距離の目標値を-100から100の間のランダムで設定。
    il[i] = random(-100, 100);
  }
  colorMode(HSB);
}

function draw(){
  background(0);
  for (let i = 0; i < angle.length; i=i+1){    //円の数だけ繰り返す
    l[i] = l[i] + (il[i] - l[i]) / 40.0;
    let x = cx + r * cos(angle[i]);    //各々の円の回転の半径と角度から、円周上の点のx座標を計算（三角関数）
    let y = cy + r * sin(angle[i]);    //各々の円の回転の半径と角度から、円周上の点のy座標を計算
    fill(0, 0, 200);
    noStroke();
    circle(x, y, 5);
    let xx = cx + (r + l[i]) * cos(angle[i]);
    let yy = cy + (r + l[i]) * sin(angle[i]);
    stroke(255);
    noFill();
    line(x, y, xx, yy);        //円周上の点からその円まで直線を引く
    noStroke();
    fill(hue[i], 255, 255);    //色相を設定する
    circle(xx, yy, 10);     //円を描画する
    angle[i] = angle[i] + 0.01;      //各々の円の回転角を0.01ずつ増やす（すると回転して見える）
  }
}
