//中心点を回る100個の円。回転の半径は円ごとに異なる
let cx;    //回転の中心座標
let cy;
let angle = new Array(100);    //各々の円の回転角度
let hue = new Array(angle.length);    //各々の円の色相
let r = new Array(angle.length);    //各々の円の回転の半径（中心点からの距離）
let ir = new Array(angle.length);    //rの目標値
function setup(){
  createCanvas(windowWidth, windowHeight);  //ウィンドウサイズの指定
  cx = width/2;
  cy = height/2;
  //それぞれの円の回転角を決める
  for (let i = 0; i < angle.length; i=i+1) {  //円の数だけ繰り返す
    //360度（2π）を円の数で割ると円1つあたりの角度のずれが計算できるので、それに配列のインデックスをかけると、その番号の円の回転角が計算できる。
    angle[i] = 2 * PI / angle.length * i;
    //255を円の数で割ると円1つあたりの色相のずれが計算できるので、それに配列のインデックスをかけて、その番号の円の色相を計算する。
    hue[i] = 255 / hue.length * i;
    //最初、全部の円の中心点からの距離は0に。それをdraw()の中でirに徐々に近づける
    r[i] = 0.0;
    //各々の円の回転の半径の目標値を200から300の間のランダムで設定。
    ir[i] = random(300, 400);
  }
  colorMode(HSB);
}

function draw(){
  background(0);
  for (let i = 0; i < angle.length; i=i+1){    //円の数だけ繰り返す
    r[i] = r[i] + (ir[i] - r[i]) / 40.0;
    let x = cx + r[i] * cos(angle[i]);    //各々の円の回転の半径と角度から、その円のx座標を計算（三角関数）
    let y = cy + r[i] * sin(angle[i]);    //各々の円の回転の半径と角度から、その円のy座標を計算
    stroke(255);
    noFill();
    line(cx, cy, x, y);        //回転の中心からその円まで直線を引く
    noStroke();
    fill(hue[i], 255, 255);    //色相を設定する
    circle(x, y, 10);     //円を描画する
    angle[i] = angle[i] + 0.01;      //各々の円の回転角を0.01ずつ増やす（すると回転して見える）
  }
}
