//多くの年の同じ日の毎時気温データの比較
let heinenchi = 22.7;    //平年の気温データ（棒グラフの基準となる）

let graphs;

let ctX;      //グラフの中心座標（共通）
let ctY;

function preload(){
  graphs = new Array(6);
  for(let i = 0; i < graphs.length; i++){
    graphs[i] = new Graph();
  }
  graphs[0].loadKionData("data/temperature20140629.csv");
  graphs[1].loadKionData("data/temperature20150629.csv");
  graphs[2].loadKionData("data/temperature20160629.csv");
  graphs[3].loadKionData("data/temperature20170629.csv");
  graphs[4].loadKionData("data/temperature20180629.csv");
  graphs[5].loadKionData("data/temperature20190629.csv");
}

function setup() {
  createCanvas(windowWidth, windowHeight);
  //中心点を算出する
  ctX = width/2;
  ctY = height/2;
  for(let i = 0; i < graphs.length; i++){
    graphs[i].initKionData();
  }
}

function draw() {
  background(0);

  //「○時」の描画
  colorMode(RGB);
  for (let i = 0; i < 24; i++) {
    let angle = PI * 2 / 24 * i - PI/2;
    let x1 = ctX + 360 * cos(angle);
    let y1 = ctY + 360 * sin(angle);
    noFill();
    stroke(100);
    line(ctX, ctY, x1, y1);

    noStroke();
    fill(255);
    textAlign(CENTER, CENTER);
    text((i+1) + "時", x1, y1);
  }

  colorMode(HSB);
  for (let i = 0; i < graphs.length; i++) {
    let col = color(255.0 / graphs.length * i, 255, 255);
    graphs[i].drawPolarGraph(ctX, ctY, 200, col, "201" + (4+i), i);
  }
}
