class Graph {

  constructor() {
    this.kion = null;
    this.x = 0.0;          //毎時のデータを表す点の座標
    this.y = 0.0;
    this.csv = null;
  }
  loadKionData(path){
    this.csv = loadTable(path, "header");
  }

  initKionData() {
    let num = this.csv.getRowCount();  //データの行数をカウント
    this.kion = new Array(num);        //行数の長さだけ配列を作る
    for (let i = 0; i < this.kion.length; i++) {  //行数の分だけループ
      let row = this.csv.getRow(i);    //csvから1行分のデータを取り出し、rowに代入する
      this.kion[i] = new Kion();      //i番目のkionの入れ物を初期化
      this.kion[i].time = int(row.getString("time"));      //"time"列のデータを整数値として取得
      this.kion[i].value = float(row.getString("temperature"));    //"temperature"列のデータを小数値として取得
    }

    this.x = new Array(this.kion.length);        //行数の長さだけxの配列を作る
    this.y = new Array(this.kion.length);        //行数の長さだけyの配列を作る
    for (let i = 0; i < this.kion.length; i++) {
      this.x[i] = 0;    //x座標
      this.y[i] = 0;    //y座標
    }
  }

  drawPolarGraph(ctX, ctY, r, col, label, labelAt) {
    //グラフの描画
    stroke(col);
    noFill();
    beginShape();
    for (let i = 0; i < this.kion.length; i++) {
      let angle = PI * 2 / this.kion.length * i - PI/2;      //その時間の角度
      let r2 = 5  * (this.kion[i].value);        //その時間の気温から半径を算出する
      let ix = (r + r2) * cos(angle);    //その時間のデータを示す点の座標
      let iy = (r + r2) * sin(angle);
      this.x[i] += (ix - this.x[i]) / 20.0;                //グラフを動かす
      this.y[i] += (iy - this.y[i]) / 20.0;
      vertex(ctX + this.x[i], ctY + this.y[i]);    //棒グラフの描画
    }
    endShape(CLOSE);

    fill(col);
    noStroke();
    text(label, ctX + this.x[labelAt], ctY + this.y[labelAt]);
  }
}
