//2017/06/29 東京 と 2018/06/29 東京 の毎時気温データの比較
let heinenchi = 22.7;    //平年の気温データ（棒グラフの基準となる）

let kion17;
let kion18;
let x;          //2017年のグラフで、毎時のデータを表す点の座標
let y;
let xx;          //2018年のグラフで、毎時のデータを表す点の座標
let yy;

let r = 200;  //グラフの半径（共通）

let ctX;      //グラフの中心座標（共通）
let ctY;

let csv17;
let csv18;

function preload(){
  csv17 = loadTable("data/temperature20170629.csv", "header");
  csv18 = loadTable("data/temperature20180629.csv", "header");
}

function setup() {
  createCanvas(windowWidth, windowHeight);
  //中心点を算出する
  ctX = width/2;
  ctY = height/2;

  //2017のデータの読みこみ
  let num = csv17.getRowCount();  //データの行数をカウント
  kion17 = new Array(num);        //行数の長さだけ配列を作る
  for (let i = 0; i < num; i++) {  //行数の分だけループ
    let row = csv17.getRow(i);    //csvから1行分のデータを取り出し、rowに代入する
    kion17[i] = new Kion();      //i番目のkionの入れ物を初期化
    kion17[i].time = int(row.getString("time"));      //"time"列のデータを整数値として取得
    kion17[i].value = float(row.getString("temperature"));    //"temperature"列のデータを小数値として取得
  }

  //2018のデータの読み込み
  num = csv18.getRowCount();  //データの行数をカウント
  kion18 = new Array(num);        //行数の長さだけ配列を作る
  for (let i = 0; i < num; i++) {  //行数の分だけループ
    let row = csv18.getRow(i);    //csvから1行分のデータを取り出し、rowに代入する
    kion18[i] = new Kion();      //i番目のkionの入れ物を初期化
    kion18[i].time = int(row.getString("time"));      //"time"列のデータを整数値として取得
    kion18[i].value = float(row.getString("temperature"));    //"temperature"列のデータを小数値として取得
  }

  //毎時の基準点となる円周上の点を算出する（2017）
  x = new Array(kion17.length);        //行数の長さだけxの配列を作る
  y = new Array(kion17.length);        //行数の長さだけyの配列を作る
  for (let i = 0; i < kion17.length; i++) {
    let angle = PI * 2 / kion17.length * i - PI/2;    //角度
    x[i] = ctX + r * cos(angle);    //x座標
    y[i] = ctY + r * sin(angle);    //y座標
  }

  //毎時の基準点となる円周上の点を算出する（2018）
  xx = new Array(kion18.length);        //行数の長さだけxの配列を作る
  yy = new Array(kion18.length);        //行数の長さだけyの配列を作る
  for (let i = 0; i < kion18.length; i++) {
    let angle = PI * 2 / kion18.length * i - PI/2;    //角度
    xx[i] = ctX + r * cos(angle);    //x座標
    yy[i] = ctY + r * sin(angle);    //y座標
  }

}

function draw() {
  background(0);

  //「○時」の描画
  for (let i = 0; i < 24; i++) {
    let angle = PI * 2 / 24 * i - PI/2;
    let x1 = ctX + 360 * cos(angle);
    let y1 = ctY + 360 * sin(angle);
    noFill();
    stroke(100);
    line(ctX, ctY, x1, y1);

    noStroke();
    fill(255);
    textAlign(CENTER, CENTER);
    text(kion17[i].time + "時", x1, y1);
  }

  //2017年のグラフの描画
  stroke(255);
  noFill();
  beginShape();
  for (let i = 0; i < kion17.length; i++) {
    let angle = PI * 2 / 24 * i - PI/2;      //その時間の角度
    let r2 = 5  * (kion17[i].value);        //その時間の気温から半径を算出する
    let ix = ctX + (r + r2) * cos(angle);    //その時間のデータを示す点の座標
    let iy = ctY + (r + r2) * sin(angle);
    x[i] += (ix - x[i]) / 20.0;                //グラフを動かす
    y[i] += (iy - y[i]) / 20.0;
    vertex(x[i], y[i]);    //棒グラフの描画
  }
  endShape(CLOSE);

  fill(255);
  noStroke();
  text("2017年6月29日", x[0], y[0]);

  //2018年のグラフの描画
  stroke(255);
  noFill();
  beginShape();
  for (let i = 0; i < kion18.length; i++) {
    let angle = PI * 2 / 24 * i - PI/2;      //その時間の角度
    let r2 = 5  * (kion18[i].value);        //その時間の気温から半径を算出する
    let ix = ctX + (r + r2) * cos(angle);    //その時間のデータを示す点の座標
    let iy = ctY + (r + r2) * sin(angle);
    xx[i] += (ix - xx[i]) / 20.0;                //グラフを動かす
    yy[i] += (iy - yy[i]) / 20.0;
    vertex(xx[i], yy[i]);    //棒グラフの描画
  }
  endShape(CLOSE);

  fill(255);
  noStroke();
  text("2018年6月29日", xx[0], yy[0]);

}
