//2017/06/29 東京の毎時気温データ
let heinenchi = 22.7;    //平年の気温データ（棒グラフの基準となる）

let kion;
let x;          //2017年のグラフで、毎時のデータを表す点の座標
let y;
let r = 200;  //グラフの半径（2017共通）

let ctX;      //2017年のグラフの中心座標
let ctY;

let csv;

function preload(){
  csv = loadTable("data/temperature20170629.csv", "header");
}

function setup() {
  createCanvas(windowWidth, windowHeight);
  //中心点を算出する
  ctX = width/2;
  ctY = height/2;

  let num = csv.getRowCount();  //データの行数をカウント
  kion = new Array(num);        //行数の長さだけ配列を作る
  for(let i = 0; i < num; i++){  //行数の分だけループ
    let row = csv.getRow(i);    //csvから1行分のデータを取り出し、rowに代入する
    kion[i] = new Kion();      //i番目のkionの入れ物を初期化
    kion[i].time = int(row.getString("time"));      //"time"列のデータを整数値として取得
    kion[i].value = float(row.getString("temperature"));    //"temperature"列のデータを小数値として取得
  }

  //毎時の基準点となる円周上の点を算出する（2017）
  x = new Array(kion.length);        //行数の長さだけxの配列を作る
  y = new Array(kion.length);        //行数の長さだけyの配列を作る
  for (let i = 0; i < kion.length; i++) {
    let angle = PI * 2 / kion.length * i - PI/2;    //角度
    x[i] = ctX + r * cos(angle);    //x座標
    y[i] = ctY + r * sin(angle);    //y座標
  }
}

function draw() {
  background(0);

  //2017年のグラフの描画
  stroke(255);
  strokeCap(SQUARE);
  noFill();
  strokeWeight(5);
  for (let i = 0; i < kion.length; i++) {
    let angle = PI * 2 / 24 * i - PI/2;      //その時間の角度
    let x1 = ctX + r * cos(angle);           //その時間の基準点の座標
    let y1 = ctY + r * sin(angle);
    let r2 = 10  * (kion[i].value - heinenchi);    //その時間の気温と平年値との差から、基準点からの距離を算出する
    let x2 = ctX + (r + r2) * cos(angle);    //その時間のデータを示す点の座標
    let y2 = ctY + (r + r2) * sin(angle);
    x[i] += (x2 - x[i]) / 20.0;                //グラフを動かす
    y[i] += (y2 - y[i]) / 20.0;
    if (r2 > 0) {       //平年値より高ければ赤で
      stroke(255, 0, 0, 200);
    } else {            //平年値より低ければ青で
      stroke(0, 0, 255, 200);
    }
    line(x1, y1, x[i], y[i]);    //棒グラフの描画
  }

  //「○時」の描画（2017）
  noStroke();
  fill(255);
  textAlign(CENTER, CENTER);
  for (let i = 0; i < 24; i++) {
    let angle = PI * 2 / 24 * i - PI/2;
    let x1 = ctX + (r-15) * cos(angle);
    let y1 = ctY + (r-15) * sin(angle);
    text(kion[i].time + "時", x1, y1);
  }

  text("2017年6月29日", width/2, height/2);
}
