//2018/06/29 東京の毎時気温データ
let heinenchi = 22.7;    //平年の気温データ（棒グラフの基準となる）

let kion;
let x;          //2018年のグラフで、毎時のデータを表す点の座標
let y;
let r = 200;  //グラフの半径（2018/2017共通）

let ctX;      //2018年のグラフの中心座標
let ctY;

let heinenR = 0.0;    //平年値を示す円の半径
let heinenIR = heinenR;    //平年値を示す円の行くべき半径

let csv;

function preload(){
  csv = loadTable("data/temperature20180629.csv", "header");
}

function setup() {
  createCanvas(windowWidth, windowHeight);
  //中心点を算出する
  ctX = width/2;
  ctY = height/2;

  let num = csv.getRowCount();  //データの行数をカウント
  kion = new Array(num);        //行数の長さだけ配列を作る
  for(let i = 0; i < num; i++){  //行数の分だけループ
    let row = csv.getRow(i);    //csvから1行分のデータを取り出し、rowに代入する
    kion[i] = new Kion();      //i番目のkionの入れ物を初期化
    kion[i].time = int(row.getString("time"));      //"time"列のデータを整数値として取得
    kion[i].value = float(row.getString("temperature"));    //"temperature"列のデータを小数値として取得
  }

  //毎時の基準点となる円周上の点を算出する（2018）
  x = new Array(kion.length);        //行数の長さだけxの配列を作る
  y = new Array(kion.length);        //行数の長さだけyの配列を作る
  for (let i = 0; i < kion.length; i++) {
    let angle = PI * 2 / kion.length * i - PI/2;    //角度
    x[i] = ctX + r * cos(angle);    //x座標
    y[i] = ctY + r * sin(angle);    //y座標
  }

  heinenR = 0;
  heinenIR = 5 * heinenchi;  //平均値から半径を算出する
}

function draw() {
  background(0);

  //2018年のグラフの描画
  stroke(255);
  strokeCap(SQUARE);
  noFill();
  strokeWeight(5);
  for (let i = 0; i < kion.length; i++) {
    let angle = PI * 2 / 24 * i - PI/2;      //その時間の角度
    let x1 = ctX + r * cos(angle);           //その時間の基準点の座標
    let y1 = ctY + r * sin(angle);
    let r2 = 5  * kion[i].value;    //その時間の気温から、基準点からの距離を算出する
    let x2 = ctX + (r + r2) * cos(angle);    //その時間のデータを示す点の座標
    let y2 = ctY + (r + r2) * sin(angle);
    x[i] += (x2 - x[i]) / 20.0;                //グラフを動かす
    y[i] += (y2 - y[i]) / 20.0;
    stroke(255);
    line(x1, y1, x[i], y[i]);    //棒グラフの描画
  }

  //平年値を示す円を描く
  noFill();
  stroke(255);
  strokeWeight(1);
  heinenR = heinenR + (heinenIR - heinenR) / 20.0;  //平年値の円を動かす
  ellipse(ctX, ctY, (r + heinenR) * 2, (r + heinenR) * 2);

  //平年値を文字で描く
  noStroke();
  fill(255);
  textAlign(LEFT, CENTER);
  text("平年値：" + heinenchi, ctX + r + heinenR + 10, ctY + 40);

  //「○時」の描画（2018）
  noStroke();
  fill(255);
  textAlign(CENTER, CENTER);
  for (let i = 0; i < 24; i++) {
    let angle = PI * 2 / 24 * i - PI/2;
    let x1 = ctX + (r-15) * cos(angle);
    let y1 = ctY + (r-15) * sin(angle);
    text(kion[i].time + "時", x1, y1);
  }
  text("2018年6月29日", width/2, height/2);
}
