let popu;  //人口データを入れるオブジェクト
let scale = 0.2;  //人口データと円の半径との比率

let font = "YuGo-Medium";
let csv;

function preload(){
  csv = loadTable("data/population2019.csv", "header");
}

function setup (){
  createCanvas(windowWidth, windowHeight);
  let num = csv.getRowCount();  //データの行数をカウント
  popu = new Array(num);

  for (let i = 0; i < num; i++) {  //行数の分だけループ
    let row = csv.getRow(i);    //csvから1行分のデータを取り出し、rowに代入する
    popu[i] = new Population();      //i番目のpopuの入れ物を初期化
    popu[i].id = int(row.getString("id"));      //"id"列のデータを整数値として取得
    popu[i].place = row.getString("都道府県名");      //"都道府県名"列のデータを文字列として取得
    popu[i].value = float(row.getString("総人口"));    //"総人口"列のデータを整数値として取得
    popu[i].x = float(row.getString("x"));      //"x"列のデータを小数値として取得
    popu[i].y = float(row.getString("y"));      //"y"列のデータを小数値として取得
    popu[i].r = 0;                      //半径を0に
    popu[i].ir = sqrt(popu[i].value * scale);  //人口の値から行くべき半径を計算する
  }
  textFont(font);
}

function draw(){
 background(0);

 for(let i = 0; i < popu.length; i++){
   popu[i].r = popu[i].r + (popu[i].ir - popu[i].r) / 10.0;
   //円の大きさで形象化
   stroke(255);
   noFill();
   if(dist(popu[i].x, popu[i].y, mouseX, mouseY) < popu[i].r){
     fill(0, 0, 255, 100);
   }
   ellipse(popu[i].x, popu[i].y, popu[i].r*2, popu[i].r*2);
   /*
   //円の色で形象化
   noStroke();
   let col = popu[i].value * 0.03;
   fill(col, 0, 0, 255);
   let r = 10 ;
   ellipse(popu[i].x, popu[i].y, r*2, r*2);
   if(dist(popu[i].x, popu[i].y, mouseX, mouseY) < r){
     fill(255);
     textSize(18);
     text(popu[i].place, popu[i].x, popu[i].y);
     textSize(12);
     text((int)popu[i].value, popu[i].x, popu[i].y+15);
   }
   */
   //文字の大きさで形象化
   /*
   fill(255);
   textSize(popu[i].r);
   textAlign(CENTER, CENTER);
   text(popu[i].place, popu[i].x, popu[i].y);
   */
 }
 for(let i = 0; i < popu.length; i++){
   //円の大きさで形象化
   if(dist(popu[i].x, popu[i].y, mouseX, mouseY) < popu[i].r){
     fill(255);
     noStroke();
     textSize(18);
     text(popu[i].place, popu[i].x, popu[i].y);
     textSize(12);
     text(int(popu[i].value), popu[i].x, popu[i].y+15);
   }
   /*
   //円の色で形象化
   let r = 10 ;
   if(dist(popu[i].x, popu[i].y, mouseX, mouseY) < popu[i].r){
     fill(255);
     textSize(18);
     text(popu[i].place, popu[i].x, popu[i].y);
     textSize(12);
     text((int)popu[i].value, popu[i].x, popu[i].y+15);
   }
   */
 }
}
