//2017/06/29 東京の毎時気温データを取得する

let kion;        //気温データを入れるオブジェクト
let x;          //毎時のデータを表す点の座標（始点）
let y;
let xx;          //毎時のデータを表す点の座標（終点）
let yy;
let len;        //気温に対応する棒グラフの長さ

let ctX;      //2018年のグラフの中心座標
let ctY;

let heinenchi = 22.7;    //平年の気温データ（棒グラフの基準となる）
let csv;

function preload (){
  csv = loadTable("data/temperature20170629.csv", "header");
}

function setup() {
  createCanvas(windowWidth, windowHeight);
  //中心点を算出する
  ctX = width/2;
  ctY = height/2;

  let num = csv.getRowCount();  //データの行数をカウント
  kion = new Array(num);        //行数の長さだけ配列を作る
  for (let i = 0; i < num; i++) {  //行数の分だけループ
    let row = csv.getRow(i);    //csvから1行分のデータを取り出し、rowに代入する
    kion[i] = new Kion();      //i番目のkionの入れ物を初期化
    kion[i].time = int(row.getString("time"));      //"time"列のデータを整数値として取得
    kion[i].value = float(row.getString("temperature"));    //"temperature"列のデータを小数値として取得
  }

  //毎時の基準点となる円周上の点を算出する（2018）
  x = new Array(kion.length);        //行数の長さだけxの配列を作る
  y = new Array(kion.length);        //行数の長さだけyの配列を作る
  len = new Array(kion.length);        //行数の長さだけlenの配列を作る
  xx = new Array(kion.length);        //行数の長さだけxxの配列を作る
  yy = new Array(kion.length);        //行数の長さだけyyの配列を作る
  for (let i = 0; i < x.length; i++) {
    x[i] = 100 + 800 / kion.length * i;
    y[i] = height/2;
    xx[i] = x[i];
    yy[i] = y[i];
    len[i] = (kion[i].value-heinenchi) * 10;
  }
}

function draw() {
  background(0);


  //2017年のグラフの描画
  stroke(255);
  strokeCap(SQUARE);
  noFill();
  strokeWeight(5);
  for (let i = 0; i < kion.length; i++) {
    let ix = x[i];
    let iy = y[i] - len[i];
    xx[i] += (ix - xx[i]) / 20.0;                //グラフを動かす
    yy[i] += (iy - yy[i]) / 20.0;
    if (kion[i].value > heinenchi) {
      stroke(255, 0, 0);
    } else {
      stroke(0, 0, 255);
    }
    line(x[i], y[i], xx[i], yy[i]);    //棒グラフの描画
  }

  //「○時」の描画
  noStroke();
  fill(255);
  textAlign(CENTER, CENTER);
  for (let i = 0; i < 24; i++) {
    text(kion[i].time + "時", x[i], y[i] + 50);
  }

  text("2017年6月29日", 100, 100);
}
