//2018/06/29 東京の毎時気温データを取得する
let kion;        //気温データを入れるオブジェクト
let graphs = new Array(0);       //グラフのエレメントの配列
let heinenchi = 22.7;    //平年の気温データ（棒グラフの基準となる）
let scale = 10;        //グラフの倍率
let csv;    //CSVデータ
let n = 0;  //グラフを順番に大きくするための番号

function preload(){
  csv = loadTable("data/temperature20180629.csv", "header");    //CSVデータの読み込み
}

function setup() {
  createCanvas(windowWidth, windowHeight);

  let num = csv.getRowCount();  //データの行数をカウント
  kion = new Array(num);        //行数の長さだけ配列を作る
  for (let i = 0; i < num; i++) {  //行数の分だけループ
    let row = csv.getRow(i);    //csvから1行分のデータを取り出し、rowに代入する
    kion[i] = new Kion();      //i番目のkionの入れ物を初期化
    kion[i].time = int(row.getString("time"));      //"time"列のデータを整数値として取得
    kion[i].value = float(row.getString("temperature"));    //"temperature"列のデータを小数値として取得
  }

  //毎時の棒グラフの始点、終点などを初期化する
  for (let i = 0; i < kion.length; i++) {
    let graph = new GraphElement();   //新しいグラフエレメントを作る
    graph.value = kion[i].value;
    graph.x = 100 + 800 / kion.length * i;   //xを横に並べる
    graph.y = height - 100;    //yを画面下に設定
    graph.ix = graph.x;   //xの目標値ixをxに同期（動かさない）
    graph.iy = graph.y;   //yの目標値iyをyに同期（動かさない）
    graph.w = 10;   //幅の初期値を設定
    graph.iw = graph.w;   //wの目標値iwをwに同期（動かさない）
    graph.h = 1;    //高さの初期値を設定
    graph.ih = kion[i].value * scale;   //棒グラフの長さを設定
    graphs.push(graph);   //配列に登録
  }
}

function draw() {
  background(0);                //背景を黒で塗りつぶす

  //グラフの描画
  stroke(255, 0, 0);        //線の色をRGBで指定
  strokeCap(SQUARE);            //線の終端の形状を四角に指定
  noFill();                     //塗りの色をなしに指定
  strokeWeight(5);              //線幅を5ピクセルに指定
  for (let i = 0; i < graphs.length; i++) {
    let graph = graphs[i];
    if(i < n){  //nより小さい番号ならアニメーションを開始する（nはdraw()の最後で増やしている）
      graph.update();
    }
    graph.draw();
  }

  //平年値の線を描画
  let heinenY = height - 100 - heinenchi * scale;
  heinenY = int(heinenY) - 0.5; //直線のレンダリングのぼやけを回避するため
  noFill();
  stroke(255, 255, 255);
  strokeWeight(1);
  line(100, heinenY, 100 + 800, heinenY);

  noStroke();
  fill(255);
  textAlign(LEFT, CENTER);
  text(heinenchi, 100+800, heinenY);

  //「○時」の描画
  noStroke();
  fill(255);
  textAlign(CENTER, CENTER);
  for (let i = 0; i < graphs.length; i++) {
    text(kion[i].time + "時", graphs[i].x, graphs[i].y + 50);    //kionの「time」変数の値を使い、「○時」と描画する
  }
  textAlign(LEFT, CENTER);
  text("2018年6月29日の気温の推移と平年値", 100, 50);

  n += 1;   //nを1増やす
}
