//円弧を描く
function setup(){
  createCanvas(windowWidth, windowHeight);  //ウィンドウサイズの指定
  background(0, 0, 0);  //背景色を指定して1回だけ塗る。
}
function draw(){
  background(0, 0, 0);  //背景を塗りつぶす
  noFill();
  stroke(0, 255, 0);
  /*
  arc()の変数は中心のx, y座標、横の直径, 縦の直径, 開始角度, 終了角度。
  開始角度から終了角度に向けて時計回りに円弧を描く。
  p5.jsでは0°〜360°ではなく、0〜2π（≒6.28）という単位を使う。
  πはPIと書き、90°がPI/2、180°がPI、360°が2πに相当する。
  */
  arc(150, 200, 200, 200, 0, PI);   //0度（真右）からπ（＝180°）まで円弧を描く
  arc(400, 200, 200, 200, PI/2, 2 * PI);  //π/2（＝90°）から2π（＝360°）まで円弧を描く
  arc(650, 200, 200, 200, PI, PI/2*3);  //π（=180°）から1.5π（＝270°）まで円弧を描く
  arc(900, 200, 200, 200, PI/2*3, PI * 3);  //1.5π（＝270°）から3π（=540°）まで円弧を描く

  //塗りの方式の違い
  fill(0, 0, 255, 80);
  stroke(255, 255, 0);
  arc(150, 500, 200, 200, 0, PI/2*3); //デフォルト。塗りはパイ型になり、始点と終点を結ぶ線はなし。
  arc(400, 500, 200, 200, 0, PI/2*3, OPEN); //「オープン（開放）」。塗りは始点と終点を結んだ形となり、始点と終点を結ぶ線はなし。
  arc(650, 500, 200, 200, 0, PI/2*3, CHORD);  //「コード（弦）」。塗りはオープンと同じだが、始点と終点が直線で結ばれ、閉じた形となる。
  arc(900, 500, 200, 200, 0, PI/2*3, PIE);  //「パイ」。デフォルトと同じくケーキのパイのように中心から切れた形となるが、始点と終点が結ばれ、閉じた形となる。
}
